/* LIBGIMP - The GIMP Library
 * Copyright (C) 1995-2003 Peter Mattis and Spencer Kimball
 *
 * gimpitemtransform_pdb.h
 *
 * This library is free software: you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library.  If not, see
 * <https://www.gnu.org/licenses/>.
 */

/* NOTE: This file is auto-generated by pdbgen.pl */

#if !defined (__GIMP_H_INSIDE__) && !defined (GIMP_COMPILATION)
#error "Only <libgimp/gimp.h> can be included directly."
#endif

#ifndef __GIMP_ITEM_TRANSFORM_PDB_H__
#define __GIMP_ITEM_TRANSFORM_PDB_H__

G_BEGIN_DECLS

/* For information look into the C source or the html documentation */


GimpItem* gimp_item_transform_translate     (GimpItem            *item,
                                             gdouble              off_x,
                                             gdouble              off_y);
GimpItem* gimp_item_transform_flip_simple   (GimpItem            *item,
                                             GimpOrientationType  flip_type,
                                             gboolean             auto_center,
                                             gdouble              axis);
GimpItem* gimp_item_transform_flip          (GimpItem            *item,
                                             gdouble              x0,
                                             gdouble              y0,
                                             gdouble              x1,
                                             gdouble              y1);
GimpItem* gimp_item_transform_perspective   (GimpItem            *item,
                                             gdouble              x0,
                                             gdouble              y0,
                                             gdouble              x1,
                                             gdouble              y1,
                                             gdouble              x2,
                                             gdouble              y2,
                                             gdouble              x3,
                                             gdouble              y3);
GimpItem* gimp_item_transform_rotate_simple (GimpItem            *item,
                                             GimpRotationType     rotate_type,
                                             gboolean             auto_center,
                                             gdouble              center_x,
                                             gdouble              center_y);
GimpItem* gimp_item_transform_rotate        (GimpItem            *item,
                                             gdouble              angle,
                                             gboolean             auto_center,
                                             gdouble              center_x,
                                             gdouble              center_y);
GimpItem* gimp_item_transform_scale         (GimpItem            *item,
                                             gdouble              x0,
                                             gdouble              y0,
                                             gdouble              x1,
                                             gdouble              y1);
GimpItem* gimp_item_transform_shear         (GimpItem            *item,
                                             GimpOrientationType  shear_type,
                                             gdouble              magnitude);
GimpItem* gimp_item_transform_2d            (GimpItem            *item,
                                             gdouble              source_x,
                                             gdouble              source_y,
                                             gdouble              scale_x,
                                             gdouble              scale_y,
                                             gdouble              angle,
                                             gdouble              dest_x,
                                             gdouble              dest_y);
GimpItem* gimp_item_transform_matrix        (GimpItem            *item,
                                             gdouble              coeff_0_0,
                                             gdouble              coeff_0_1,
                                             gdouble              coeff_0_2,
                                             gdouble              coeff_1_0,
                                             gdouble              coeff_1_1,
                                             gdouble              coeff_1_2,
                                             gdouble              coeff_2_0,
                                             gdouble              coeff_2_1,
                                             gdouble              coeff_2_2);


G_END_DECLS

#endif /* __GIMP_ITEM_TRANSFORM_PDB_H__ */
